/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import java.io.Serializable;
import java.util.Date;

public final class RbfErrorDetail
implements Serializable {
    private static final long serialVersionUID = -8980948914460152617L;
    private static final FcsServer fcsServer = FcsServer.getFcsServer();
    private int reasonCode;
    private String diagnostic;
    private MachineId origin;
    private Date date;
    public static final int REASON_ENCODE_ERROR = 1056;
    public static final int REASON_DECODE_ERROR = 1057;
    public static final int REASON_CONSTRUCT_ERROR = 1058;
    public static final int REASON_UNCAUGHT_ERROR = 1059;
    public static final int REASON_PROTOCOL_ERROR = 1060;
    public static final int REASON_PERSISTENCE_ERROR = 1061;

    public RbfErrorDetail(int reasonCode) {
        this(reasonCode, null);
    }

    public RbfErrorDetail(int reasonCode, String diagnostic) {
        this.reasonCode = reasonCode;
        this.diagnostic = diagnostic;
        this.origin = fcsServer.getLocalMachineId();
        this.date = new Date();
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public void setOrigin(MachineId origin) {
        if (origin == null) {
            throw new IllegalArgumentException("Null origin machine");
        }
        this.origin = origin;
    }

    public MachineId getOrigin() {
        return this.origin;
    }

    public void setDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RbfErrorDetail:\n");
        sb.append("reason=" + this.reasonCode + "\n");
        sb.append("diagnostic=" + this.diagnostic + "\n");
        sb.append("origin=" + this.origin.getName() + "\n");
        sb.append("date=" + this.date + "]");
        return sb.toString();
    }
}

